<?php
defined( 'BASEPATH' ) OR exit( 'No direct script access allowed' );

class Achievements_user extends MY_Controller {

    
    /**
     * Achievements User
     * 
     * @return void
     */

    public function index()
    {
        if( ! $this->zuser->is_logged_in ) env_redirect( 'login' );

        check_page_authorization( 'achievements_user' );

        $this->area = 'admin';
        $this->load->model( 'User_model' );

        $data['data']['achievements_user'] = $this->User_model->get_achievements_user();

        $data['title'] = 'Prestasi Pengguna';
        $data['view'] = 'achievements_user/index';

        $this->load_panel_template( $data, false );
    }

    public function update($user_id)
    {
        if( ! $this->zuser->is_logged_in ) env_redirect( 'login' );

        check_page_authorization( 'achievements_user' );

        $this->area = 'admin';

        $data['title'] = 'Edit Prestasi Pengguna';
        $data['view'] = 'achievements_user/edit';
        $data['data']['user_id'] = $user_id;
        
        $this->load->model( 'Achievements_user_model' );

        $achievements = $this->Achievements_user_model->achievement($user_id);
        if( $achievements )
        {
            $data['data']['content'] = $achievements->content;
        }

        $this->load_panel_template( $data, false );
    }
}