<?php
defined( 'BASEPATH' ) OR exit( 'No direct script access allowed' );

class Announcements_per_user extends MY_Controller {

    
    /**
     * Announcements User
     * 
     * @return void
     */

    public function index()
    {
        if( ! $this->zuser->is_logged_in ) env_redirect( 'login' );

        check_page_authorization( 'announcement_per_user' );

        $this->area = 'admin';
        $this->load->model( 'User_model' );

        $data['data']['announcements'] = $this->User_model->get_announcements();

        $data['title'] = 'Announcements Per User';
        $data['view'] = 'announcements_per_user/index';

        $this->load_panel_template( $data, false );
    }

    public function update($user_id)
    {
        if( ! $this->zuser->is_logged_in ) env_redirect( 'login' );

        check_page_authorization( 'achievements_user' );

        $this->area = 'admin';

        $data['title'] = 'Edit Prestasi Pengguna';
        $data['view'] = 'announcements_per_user/edit';
        $data['data']['user_id'] = $user_id;
        
        $this->load->model( 'Announcement_per_user_model' );

        $achievements = $this->Announcement_per_user_model->announcement($user_id);
        if( $achievements )
        {
            $data['data']['content'] = $achievements->content;
        }

        $this->load_panel_template( $data, false );
    }
}