<?php defined( 'BASEPATH' ) OR exit( 'No direct script access allowed' ); ?>
<div class="content">
  <div class="container-fluid">
    <div class="row">
      
      <div class="col-12">

        <div class="card">
          <div class="card-header d-flex align-items-center">
            <h3 class="card-title">
              <!-- Ganti Bahasa -->
              <?php echo lang( 'achievements_user' ); ?>
            </h3>
          </div>
          
          <div class="card-body pt-0 pb-0 records-card-body">
            <div class="table-responsive">
              <table class="custom-table z-table table table-striped text-nowrap table-valign-middle mb-0">
                <thead class="records-thead">
                  <tr>
                    <th class="th-1"><?php echo lang( 'id' ); ?></th>
                    <th class="th-2"><?php echo lang( 'name' ); ?></th>
                    <th class="th-2"><?php echo lang( 'bussiness_type' ); ?></th>
                    <th class="text-right th-2"><?php echo lang( 'updated' ); ?></th>
                    <th class="text-right th-2"><?php echo lang( 'actions' ); ?></th>
                  </tr>
                </thead>
                <tbody class="records-tbody text-sm">
                  <?php if ( ! empty( $achievements_user ) ): ?>
                    <?php foreach($achievements_user as $key => $user ): ?>
                      <tr id="record-<?php echo html_escape($user->id); ?>">
                        <td><?php echo ($key + 1); ?></td>
                        <td><?php echo html_escape($user->full_name); ?></td>
                        <td><?php echo ($user->bussiness_name) ? html_escape($user->bussiness_name) : "Belum memilih Jenis Usaha / Karya"; ?></td>
                        <td class="text-right">
                          <?php echo ($user->update_at) ? html_escape(date('H:i d-m-Y', $user->update_at)) : "Belum pernah dirubah"; ?>
                        </td>
                        <td class="text-right">
                          <a href="<?php echo base_url() . "admin/achievements_user/" . html_escape($user->id) . "/update" ?>" class="btn btn-success">
                            <span class="fas fa-edit"></span>
                          </a>
                          <a href="#" target="_blank" class="btn btn-info">
                            <span class="fas fa-eye"></span>
                          </a>
                        </td>
                      </tr>
                    <?php endforeach ?>
                  <?php else: ?>
                    <tr id="record-0">
                      <td colspan="6">
                        <?php echo lang( 'no_records_found' ); ?>
                      </td>
                    </tr>
                  <?php endif ?>
                </tbody>
              </table>
            </div>
          </div>
          <!-- /.card-body -->

        </div>
        <!-- /.card-tools -->


      </div>
      <!-- div.col-12 -->
    </div>
  </div>
</div>