<?php defined( 'BASEPATH' ) OR exit( 'No direct script access allowed' ); ?>
<div class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-sm-12">
        <div class="not-in-form">
          <div class="response-message"></div>
        </div>
        <!-- /.not-in-form -->
        <div class="card">
          <div class="card-header d-flex align-items-center">
            <h3 class="card-title"><?php echo lang( 'users_invites' ); ?></h3>
            <div class="card-tools ml-auto">
              <button class="btn btn-success text-sm" data-toggle="modal" data-target="#invite-user">
                <i class="fas fa-paper-plane mr-2"></i> <?php echo lang( 'invite_user' ); ?>
              </button>
            </div>
            <!-- /.card-tools -->
          </div>
          <!-- /.card-header -->
          <div class="card-body pt-0 pb-0 records-card-body">
            <div class="table-responsive">
              <table class="custom-table z-table table table-striped text-nowrap table-valign-middle mb-0">
                <thead class="records-thead">
                  <tr>
                    <th class="th-1"><?php echo lang( 'id' ); ?></th>
                    <th class="th-2"><?php echo lang( 'email_address' ); ?></th>
                    <th class="th-2"><?php echo lang( 'invitation_code' ); ?></th>
                    <th><?php echo lang( 'user_registered' ); ?></th>
                    <th class="text-right"><?php echo lang( 'status' ); ?></th>
                    <th class="text-right th-2"><?php echo lang( 'updated' ); ?></th>
                    <th class="text-right th-2"><?php echo lang( 'created' ); ?></th>
                    <th class="text-right th-2"><?php echo lang( 'actions' ); ?></th>
                  </tr>
                </thead>
                <tbody class="records-tbody text-sm">
                  <?php
                  if ( ! empty( $invites ) )
                  {
                    foreach ( $invites as $invite ) {
                      $id = $invite->id; ?>
                      <tr id="record-<?php echo html_escape( $id ); ?>">
                        <td><?php echo html_escape( $id ); ?></td>
                        <td><?php echo html_escape( $invite->email_address ); ?></td>
                        <td><?php echo html_escape( $invite->invitation_code ); ?></td>
                        <td>
                          <?php
                          if ( ! empty( $invite->user_id ) )
                          {
                              if ( ! empty( $invite->full_name ) )
                              {
                                  echo '<a href="' . env_url( 'admin/users/edit_user/' . html_escape( $invite->user_id ) ) . '">';
                                  echo html_escape( $invite->full_name );
                                  echo '</a>';
                              }
                              else
                              {
                                  echo lang( 'user_deleted' );
                              }
                          }
                          else
                          {
                              echo lang( 'not_registered' );
                          }
                          ?>
                        </td>
                        <td class="text-right">
                          <span class="badge badge-primary"><?php echo lang( get_invitation_status( $invite ) ); ?></span>
                        </td>
                        <td class="text-right"><?php manage_updated_at( html_escape( $invite->updated_at ) ); ?></td>
                        <td class="text-right"><?php echo get_date_time_by_timezone( html_escape( $invite->invited_at ) ); ?></td>
                        <td class="text-right">
                          <div class="btn-group">
                            <?php if ( $invite->status != 1 ) { ?>
                              <button class="btn btn-sm btn-primary get-data-tool" data-source="<?php admin_action( 'users/edit_user_invitation' ); ?>" data-id="<?php echo html_escape( $id ); ?>">
                                <span class="fas fa-edit get-data-tool-c"></span>
                              </button>
                            <?php } else { ?>
                              <button class="btn btn-sm btn-primary" disabled>
                                <span class="fas fa-edit"></span>
                              </button>
                            <?php } ?>
                            <button class="btn btn-sm btn-danger tool" data-id="<?php echo html_escape( $id ); ?>" data-toggle="modal" data-target="#delete">
                              <i class="fas fa-trash tool-c"></i>
                            </button>
                          </div>
                          <!-- /.btn-group -->
                        </td>
                      </tr>
                      <?php }
                    } else {
                  ?>
                    <tr id="record-0">
                      <td colspan="8"><?php echo lang( 'no_records_found' ); ?></td>
                    </tr>
                  <?php } ?>
                </tbody>
              </table>
            </div>
            <!-- /.table-responsive -->
            
            <div class="clearfix"><?php echo $pagination; ?></div>
            
          </div>
          <!-- /.card-body -->
        </div>
        <!-- /.card -->
      </div>
      <!-- /.col -->
    </div>
    <!-- /.row -->
  </div>
  <!-- /.container-fluid -->
</div>
<!-- /.content -->

<?php load_modals( ['admin/invite_user', 'read', 'delete'] ); ?>