<?php defined( 'BASEPATH' ) OR exit( 'No direct script access allowed' ); ?>
<?php if ( ! is_public_page() ) { ?>
  <footer class="footer-z bg-white pb-md-0 shadow">
    <div class="container">
      <div class="row">
        <div class="col-md-6">
          <div class="d-flex justify-content-center align-items-center py-3">
            <p class="mb-0 ms-1">
              Copyright <?php printf( date( 'Y' ) ); ?>. PT. Digital Advisor Akademi
            </p>
            <!-- /.dropdown -->
          </div>
          <!-- /div -->
        </div>
        <!-- /col -->
      </div>
      <!-- /.row -->
    </div>
    <!-- /.container -->
  </footer>
  
  <?php load_view( 'common/public/chat_box' ); ?>
  
<?php } ?>

<?php if ( db_config( 'site_show_cookie_popup' ) ) { ?>
  <div class="cookie-popup card border-0 bg-sub shadow-lg">
    <div class="card-body">
      <p><?php echo lang( 'cookie_message' ); ?></p>
      <div class="d-grid">
        <button class="btn btn-light accept-btn text-uppercase accept-btn"><?php echo lang( 'got_it' ); ?></button>
      </div>
      <!-- /.d-grid -->
    </div>
    <!-- /.card-body -->
  </div>
  <!-- /.cookie-popup -->
<?php } ?>

<?php if ( db_config( 'site_custom_css' ) ) { ?>
  <!-- Custom CSS ( From Admin Panel ): -->
  <style><?php echo html_escape( db_config( 'site_custom_css' ) ); ?></style>
<?php } ?>

<?php if ( ! empty( db_config( 'google_analytics_id' ) ) ) { ?>
  <!-- Global site tag (gtag.js) - Google Analytics -->
  <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo html_escape( db_config( 'google_analytics_id' ) ); ?>"></script>
<?php } ?>

<?php if ( is_gr_togo() && ! empty( $gr_field ) ) { ?>
  <!-- Google reCaptcha: -->
  <script src="https://www.google.com/recaptcha/api.js" async defer></script>
<?php } ?>

<?php if ( ! empty( $scripts ) )
  load_scripts( $scripts );
?>

<!-- Pace JS: -->
<script src="<?php assets_path( 'vendor/pace/pace.js' ); ?>"></script>

<!-- jQuery Cookie: -->
<script src="<?php assets_path( 'vendor/jquery-cookie/jquery.cookie.js' ); ?>"></script>

<!-- Bootstrap JS: -->
<script src="<?php assets_path( 'vendor/bootstrap/js/bootstrap.bundle.min.js' ); ?>"></script>

<!-- Select 2: -->
<script src="<?php assets_path( 'vendor/select2/js/select2.full.min.js' ); ?>"></script>

<!-- Custom Scripts: -->
<script src="<?php assets_path( 'js/functions.js?v=' . v_combine() ); ?>"></script>
<script src="<?php assets_path( 'js/script.js?v=' . v_combine() ); ?>"></script>
<script src="<?php assets_path( 'js/script_public.js?v=' . v_combine() ); ?>"></script>

</body>

</html>