<?php defined( 'BASEPATH' ) OR exit( 'No direct script access allowed' ); ?>
<div class="register-container container p-0">
  <div class="row w-100 h-100 m-0">
    <div class="col-12 col-md-6 col-lg-8 d-none d-md-flex hero-container d-flex align-items-center justify-content-center">
      <video autoplay muted loop height="560px" width="100%">
        <source src="<?php echo base_url('/assets/default/images/animation-1.mp4') ?>" type="video/mp4" />
      </video>
    </div>
    <div class="form-container col-12 col-md-6 col-lg-4 d-flex flex-column overflow-auto align-items-center py-5 overflow-auto" style="max-height: 100vh;">
      <a class="mb-2" href="<?php echo base_url() ?>">
        <img src="<?php echo general_uploads( html_escape( db_config( 'site_favicon' ) ) ); ?>" class="mb-2" alt="mageti" width="60px" height="60px"/>
      </a>
      <h1 class="mb-3 fw-bold" style="font-size: 1.8rem;">Daftar Akun</h1>
      <div class="w-100 px-3">
      <form class="z-form" action="<?php echo env_url( 'actions/account/register' ); ?>" method="post" data-csrf="manual">
          <div class="response-message"><?php echo alert_message(); ?></div>
          <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
          <div class="mb-3">
            <label class="form-label" for="full_name"><?php echo lang( 'full_name' ); ?></label>
            <input type="text" class="form-control" id="full_name" name="full_name" placeholder="<?php echo lang( 'full_name' ); ?>" required>
          </div>
          <!-- /.mb-3 -->
          <div class="mb-3">
            <label class="form-label" for="email_address"><?php echo lang( 'email_address' ); ?></label>
            <?php if ( ! empty( $email_address ) ) { ?>
              <input type="email" class="form-control" id="email_address" name="email_address" placeholder="<?php echo lang( 'email_address' ); ?>" value="<?php echo html_escape( $email_address ); ?>" readonly>
            <?php } else { ?>
              <input type="email" class="form-control" name="email_address" placeholder="<?php echo lang( 'email_address' ); ?>" required>
            <?php } ?>
          </div>
          <!-- /.mb-3 -->
          <div class="mb-3">
            <label class="form-label" for="password"><?php echo lang( 'password' ); ?></label>
            <input type="password" class="form-control" id="password" name="password" placeholder="<?php echo lang( 'password' ); ?>" required>
          </div>
          <!-- /.mb-3 -->
          <div class="mb-3">
            <label class="form-label" for="retypePassword"><?php echo lang( 'retype_password' ); ?></label>
            <input type="password" class="form-control" id="retypePassword" name="retype_password" placeholder="<?php echo lang( 'retype_password' ); ?>" required>
          </div>
          <!-- /.mb-3 -->
          <div class="mb-3">
            <label class="form-label" for="birth_date"><?php echo lang('birth_date') ?></label>
            <input type="date" class="form-control" id="birth_date" name="birth_date" placeholder="<?php echo lang('birth_date') ?>" required>
          </div>
          <!-- /.mb-3 -->
          <div class="mb-3">
            <label class="d-block form-label"><?php echo lang( 'gender' ); ?></label>
            <div class="form-check d-inline-block me-3">
              <input class="form-check-input" type="radio" name="gender" id="gender-male" value="L" required>
              <label class="form-check-label" for="gender-male"><?php echo lang( 'male' ); ?></label>
            </div>
            <div class="form-check d-inline-block">
              <input class="form-check-input" type="radio" name="gender" id="gender-female" value="P" required>
              <label class="form-check-label" for="gender-female"><?php echo lang( 'female' ); ?></label>
            </div>
          </div>
          <!-- /.mb-3 -->
          <div class="mb-3">
            <label for="bussiness_type" class="form-label"><?php echo lang( 'bussiness_type' ); ?></label>
            <select id="bussiness_type" class="form-control select2 search-disabled" name="bussiness_type" data-placeholder="<?php echo lang( 'bussiness_type' ); ?>" required>
              <option></option>
              <?php if ( ! empty( $bussiness_type ) ) {
                foreach ( $bussiness_type as $bussiness ) { ?>
                <option value="<?php echo html_escape( $bussiness->id ); ?>"><?php echo html_escape( $bussiness->name ); ?></option>
              <?php }
              } ?>
            </select>
          </div>
          <!-- /.mb-3 -->
          <div class="mb-3">
            <label class="form-label" for="bussiness_name"><?php echo lang( 'bussiness_name' ); ?></label>
            <input type="text" class="form-control" id="bussiness_name" name="bussiness_name" placeholder="<?php echo lang( 'bussiness_name' ); ?>" >
          </div>
          <!-- /.mb-3 -->
          <div class="mb-3">
            <label class="form-label" for="prestasi">Prestasi</label>
            <textarea class="form-control" name="prestasi" rows="3" id="prestasi"></textarea>
          </div>
          <!-- /.mb-3 -->
          <div class="mb-3">
            <label class="form-label" for="bussiness_address">Alamat Karya / Usaha</label>
            <input type="text" class="form-control" id="bussiness_address" name="bussiness_address"/>
          </div>
          <!-- /.mb-3 -->
          <div class="mb-3">
            <label class="form-label" for="reasonJoin">Alasan Join</label>
            <input type="text" class="form-control" id="reasonJoin" name="reason_join" required/>
          </div>
          <div class="mb-3">
            <label class="form-label" for="userDream">Ceritakan impian singkat terhadap karyamu</label>
            <textarea class="form-control" rows="3" name="user_dream" id="userDream"></textarea>
          </div>
          <!-- /.mb-3 -->
          <div class="mb-3 form-check">
            <input type="checkbox" class="form-check-input" id="agree" name="terms" required>
            <label class="form-check-label" for="agree"><?php printf( lang( 'agree_terms' ), env_url( 'terms' ) ); ?></label>
          </div>
          <!-- /.mb-3 -->
          <?php if ( is_gr_togo() ) { ?>
            <div class="mb-2 text-center">
              <div class="g-recaptcha d-inline-block" data-sitekey="<?php echo html_escape( db_config( 'gr_public_key' ) ); ?>"></div>
            </div>
            <!-- /.mb-2 -->
          <?php } ?>
          <div class="d-grid">
            <button class="btn btn-sub" type="submit"><?php echo lang( 'register' ); ?></button>
          </div>
          <!-- /.d-grid -->
          
          <?php load_view( 'user/account/social_auth_links' ); ?>
          
          <?php if ( ! empty( $code ) ) { ?>
            <input type="hidden" name="invitation_code" value="<?php echo html_escape( $code ); ?>">
          <?php } ?>
        </form>

        <p class="mt-3 text-center"><?php printf( lang( 'already_have_account' ), env_url( 'login' ) ); ?></p>
      </div>
    </div>
  </div>
</div>