<?php
defined( 'BASEPATH' ) OR exit( 'No direct script access allowed' );
$count_col = ( $this->zuser->has_permission( 'users' ) ) ? 'col-md-6' : 'col-md-6';
?>
<div class="content">
  <div class="container-fluid">
    <div class="row dashboard">
      <div class="col-sm-12">
        <div class="not-in-form">
          <div class="response-message"><?php echo alert_message(); ?></div>
        </div>
        
        <!-- /.not-in-form -->
        <div class="row">
          <?php if ( $this->zuser->has_permission( 'tickets' ) ) { ?>
            <div class="col-12 col-sm-6 <?php echo html_escape( $count_col ); ?>">
              <div class="info-box">
                <span class="info-box-icon bg-info"><i class="fas fa-folder-open"></i></span>
                <div class="info-box-content">
                  <a class="info-box-text" href="<?php echo env_url( 'admin/tickets/opened' ); ?>"><?php echo lang( 'opened_tickets' ); ?></a>
                  <span class="info-box-number"><?php echo html_escape( $dashboard['opened_tickets'] ); ?></span>
                </div>
                <!-- /.info-box-content -->
              </div>
              <!-- /.info-box -->
            </div>
            <!-- /.col -->
            <div class="col-12 col-sm-6 <?php echo html_escape( $count_col ); ?>">
              <div class="info-box mb-3">
                <span class="info-box-icon bg-danger"><i class="fas fa-folder"></i></span>
                <div class="info-box-content">
                  <a class="info-box-text" href="<?php echo env_url( 'admin/tickets/closed' ); ?>"><?php echo lang( 'closed_tickets' ); ?></a>
                  <span class="info-box-number"><?php echo html_escape( $dashboard['closed_tickets'] ); ?></span>
                </div>
                <!-- /.info-box-content -->
              </div>
              <!-- /.info-box -->
            </div>
            <!-- /.col -->

            <!-- Fix for Small Devices Only: -->
            <div class="clearfix hidden-md-up"></div>
            
            <div class="col-12 col-sm-6 <?php echo html_escape( $count_col ); ?>">
              <div class="info-box mb-3">
                <span class="info-box-icon bg-success"><i class="fas fa-list-ul"></i></span>
                <div class="info-box-content">
                  <a class="info-box-text" href="<?php echo env_url( 'admin/tickets/all' ); ?>"><?php echo lang( 'all_tickets' ); ?></a>
                  <span class="info-box-number"><?php echo html_escape( $dashboard['all_tickets'] ); ?></span>
                </div>
                <!-- /.info-box-content -->
              </div>
              <!-- /.info-box -->
            </div>
            <!-- /.col -->
          <?php } ?>
          
          <?php if ( $this->zuser->has_permission( 'users' ) ) { ?>
            <div class="col-12 col-sm-6 <?php echo html_escape( $count_col ); ?>">
              <div class="info-box mb-3">
                <span class="info-box-icon bg-warning"><i class="fas fa-users"></i></span>
                <div class="info-box-content">
                  <a class="info-box-text" href="<?php echo env_url( 'admin/users/manage' ); ?>"><?php echo lang( 'total_users' ); ?></a>
                  <span class="info-box-number"><?php echo html_escape( $dashboard['total_users'] ); ?></span>
                </div>
                <!-- /.info-box-content -->
              </div>
              <!-- /.info-box -->
            </div>
            <!-- /.col -->
          <?php } ?>
        </div>

        
        <div class="row">
          <div class="col-12 col-md-6">
            <div class="card">
              <div class="card-header">
                <h3 class="card-title"><?php echo lang('statistic_user') ?></h3>
              </div>
              <div class="card-body">
                <canvas id="chartBussinessType"></canvas>
              </div>
            </div>
          </div>
          <!-- /.end col-12 -->
          <div class="col-12 col-md-6">
            <div class="card">
              <div class="card-header">
                <h3 class="card-title"><?php echo lang('statistic_gender') ?></h3>
              </div>
              <div class="card-body">
                <canvas id="chartGender"></canvas>
              </div>
            </div>
          </div>
          <!-- /.end col-12 -->
          <div class="col-12 col-md-6">
            <div class="card">
              <div class="card-header">
                <h3 class="card-title"><?php echo lang('statistic_age') ?></h3>
              </div>
              <div class="card-body">
                
              </div>
            </div>
          </div>
          <?php if ( $this->zuser->has_permission( 'tickets' ) ) { ?>
            <div class="col-12 col-lg-6">
              <div class="card">
                <div class="card-header">
                  <h3 class="card-title"><?php echo lang( 'tickets_statistics' ); ?></h3>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                  <?php $counts = json_decode( $dashboard['recent_tickets_stats'], true ); ?>
                  <canvas id="chart"></canvas>
                  <input type="hidden" class="tickets_stats_months" value="<?php echo implode( ',', html_escape( array_keys( $counts ) ) ); ?>">
                  <input type="hidden" class="tickets_stats_counts" value="<?php echo implode( ',', html_escape( array_values( $counts ) ) ); ?>">
                </div>
                <!-- /.card-body -->
              </div>
              <!-- /.card -->
            </div>
            <!-- /.col -->
          <?php } ?>
          
        </div>
        <!-- /.row -->
      </div>
      <!-- /.col -->
    </div>
    <!-- /.row -->
  </div>
  <!-- /.container-fluid -->
</div>
<!-- /.content -->

<script>

  function setUpStatistic( element, data, { label, type } = { label: 'Chart', type: 'pie'} ) {
    new Chart(element, {
      type: 'pie',
      data: {
        labels: data.map((item => (item.name) ? item.name : '')),
        datasets: [{
          label,
          data: data.map((item) => item.value),
          backgroundColor: [
            'rgb(255, 99, 132)',
            'rgb(54, 162, 235)',
            'rgb(255, 205, 86)',
            'rgb(220, 53, 69)',
            'rgb(53, 220, 79)',
            'rgb(238, 247, 41)',
            'rgb(255, 138, 210)'
          ],
          borderWidth: 1
        }]
      },
      options: {
        title: {
          display: true,
          text: label
        }
      }
    })
  }

  (async function () {
    // Fetch statistic busssiness type
    const chartBussinessType = document.getElementById('chartBussinessType');
    try {
      const response = await fetch('<?php echo base_url("/actions/admin/statistics/bussiness_type") ?>');
      const responseJson = await response.json();
      if( Array.isArray(responseJson.value) ) {
        const bussinessTypeData = responseJson.value.map((bussiness) => ({ 
          name: (bussiness.name) ? bussiness.name : 'Belum Memilih', 
          value: bussiness.total
        }));

        setUpStatistic(chartBussinessType, bussinessTypeData, { label: 'Jumlah pengguna setiap jenis karya' });
      }else{
        alert('Malformed format data');
      }
    } catch(err) {
      alert('Gagal mendapatkan statistik jenis karya');
      console.erro(err)
    }

    // Fetch statistik gender
    const chartGender = document.getElementById('chartGender');
    try {
      const response = await fetch('<?php echo base_url("/actions/admin/statistics/gender") ?>');
      const responseJson = await response.json();
      if( Array.isArray(responseJson.value) ) {
        const genderData = responseJson.value.map((gender) => ({ 
          name: (gender.name) ? gender.name : 'Belum Memilih', 
          value: gender.count
        }));

        setUpStatistic(chartGender, genderData, { label: 'Jenis Kelamin' });
      }else{
        alert('Malformed format data');
      }
    } catch(err) {
      alert('Gagal mendapatkan statistik jenis kelamin');
      console.error(err)
    }

  })();
</script>