<?php defined( 'BASEPATH' ) OR exit( 'No direct script access allowed' ); ?>

<div class="submit-article my-5">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <div class="response-message no-radius"><?php echo alert_message(); ?></div>
      </div>
      <div class="col-12 mb-2">
        <h1 class="mb-0" style="font-size: 24px" align="center">Kirim Artikel 4 Pilar #BergerakBerkarya</h1>
      </div>
      <div class="col-12">
        <lottie-player
          src="<?php echo base_url('assets/default/lottiefiles/loading.json') ?>"
          speed="1"
          class="loading mx-auto"
          style="width: 100%; max-width: 500px; height: 200px;"
          mode="normal"
          loop
          autoplay
        ></lottie-player>
       <form class="d-none" id="submitArticle" action="<?php user_action( 'support/create_ticket' ); ?>">
         <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
         <div class="form-group mb-3">
           <label class="form-label" for="title">Judul</label>
           <input class="form-control form-control-lg" type="text" id="title" name="title" placeholder="Judul Artikel">
         </div>
         <div class="mb-3">
           <textarea name="content" id="content" cols="10" rows="10" width="100%"></textarea> 
         </div>
         <button type="submit" class="btn btn-primary" disabled>Kirim</button>
       </form> 
      </div>
    </div>
  </div>
</div>

<script>
  const formArticle = document.getElementById('submitArticle');
  const submitButton = formArticle.querySelector('button[type="submit"]');

  tinymce.init({
    selector: 'textarea#content',
    plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount checklist mediaembed casechange export formatpainter pageembed linkchecker a11ychecker tinymcespellchecker permanentpen powerpaste advtable advcode editimage tinycomments tableofcontents footnotes mergetags autocorrect typography inlinecss',
    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table mergetags | addcomment showcomments | spellcheckdialog a11ycheck typography | align lineheight | checklist numlist bullist indent outdent | emoticons charmap | removeformat',
    promotion: false,
    menubar: false,
    height: 520
  }).then((editor) => {
    submitButton.disabled = false;
    document.querySelector('lottie-player.loading').classList.add('d-none');
    document.querySelector('form#submitArticle').classList.remove('d-none');
  })

  formArticle.addEventListener('submit', async (event) => {
    event.preventDefault();
    submitButton.disabled = true;
    
    const form = event.target;
    const editor = tinymce.get("content");

    const data = new FormData(formArticle, submitButton);
    data.delete("content");
    data.append("content", editor.getContent());

    const headers = {
      "x-requested-with": "XMLHttpRequest"
    }

    const response = await fetch("<?php echo base_url('/actions/user/support/submit_article') ?>", { method: "POST", body: data, headers });
    const responseText= await response.text();

    manageSuccessResponse( form, responseText );

    submitButton.disabled = false;

  })
</script>